 ;MAINS INTERFACE DIMMER CODE v2.01
 ;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ;COMMENTS
 ;~~~~~~~~
 ;triggering interrupt on +ve edge
 ;only
 ;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ;
 ;list r=dec ;Default radix decimal
 ;list p=pic16f84 ;Device
 ;__config %11111111110001;Configuration
 ;Program code protection off
 ;Power-up timer enabled
 ;Watchdog timer disabled
 ;XT xtal selected
 ;
w equ 0 ;working register flag
 ;
 ;BANK 0
 ;+-----
Pcl equ $02 ;
Status equ $03 ;
Rp0 equ 5 ;
Rp1 equ 6;
c equ 0 ;
f equ 1 ;file register flag
z equ 2 ;
 ;
Porta equ $05 ;
Ra3 equ 3 ;
Ra4 equ 4 ;
Portb equ $06 ;
Intcon equ $0B ;
Inte equ 4;
Intf equ 1;
Gie equ 7 ;
 Eeie equ 6 ;
 ;
 ;BANK 1
 ;+-----
Option equ $01 ;
Intedg equ 6;
Trisa equ $05 ;
Trisb equ $06 ;
 ;
 ;
DlyVal equ $0C ;Light intensity delay value in 1/10ms
 ;
 ;Switches (on port a)
Up_sw equ 0;
Down_sw equ 1;
 ;
Triac_drv equ 1 ;Triac driver (on port b)
 ;
Nop_count equ $0D ;No operation counter
DyVlLp equ $0E;Light value delay loop counter
 ;
 ;Interrupt preserve registers
W_temp equ $0F ;w
Status_temp equ $10 ;status
DyVlLpTp equ $11;Temporary delay loop counter
 ;
SwDlyVal equ $12 ;Slow down switch loop counter
 ;
 ;**********************************
 ;
 ;START OF PROGRAMME CODE
 ;+*SPC~~~~~~~~~~~~~~~~~~~~~~
 org $0000 ;
 goto Start;
 ;
 org $0004;Interrupt vector
 goto intrpt;
 ;
 org $0005;
Start: ;
 call Con_io;Configure in/out registers
 call Init_var;Initialise variables
 ;
 bsf status,rp0;Bank 1
 bsf option,intedg;Set interrupt on rising edge
 bcf status,rp0;Bank 0
 ;
 bsf intcon,gie;Enable global interrupts
 bsf intcon,inte;Enable rb0 interrupts
 ;
 goto Main_lp ;
 ;
 ;
 ;BEGINNING OF MAIN PROGRAMME LOOP
 ;+*BMPL~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ;
Main_lp: ;
 ;Operate under rb0 interrupts
 call Chk_up;Check lite up switch
 call Chk_dwn;Check lite down switch
 ;
 ;+*DBG~~~~~~~~~~~~~~~~~~
 ;call Intrpt;
 ;+*EDBG~~~~~~~~~~~~~~~~~~
 goto Main_lp;
 ;
 ;END OF MAIN PROGRAMME LOOP
 ;+*EMPL~~~~~~~~~~~~~~~~~~~~
 ;
 ;*************************************
 ;
 ;INTERRUPT SERVICE ROUTINE
 ;+*ISR~~~~~~~~~~~~~~~~~~~~
 ;
Intrpt: ;
 ;Save registers
 movwf W_temp;
 swapf status,w;
 movwf Status_temp;
 movf DyVlLp,w;
 movwf DyVlLpTp;
 ;Main service routine starts here
 ;
 ;Check triac trigger delay values
 ;
 ;Check if max value and if so go to
 ;max value routine ie skip delay
 movf DlyVal,w;
 ;Move delay value into loop counter
 movwf DyVlLp;
 sublw 11;
 btfsc status,z;
 goto MaxVal;
 ;Check if min value and if so go to
 ;min value routine ie skip delay
 movf DlyVal,w;
 ;Move delay value into
 ;loop counter
 movwf DyVlLp;
 sublw 81;
 btfsc status,z;
 goto MinVal;
MidVal: ;
 ;Delay appropriate time
 call Dly_x_ms;
 ;
 call Tr_on;
 ;Use 0.2ms pulse
 call dly_p1ms;
 call dly_p1ms;
 ;Switch triac off
 call Tr_off;
 ;Actual switch off at next zero
 ;crossing
 ;
 ;Wait 10ms (half mains cycle)
 movlw 100;
 movwf DyVlLp;
 call Dly_x_ms;
 ;Switch triac on
 call Tr_on;
 ;Use 0.2ms pulse
 call dly_p1ms;
 call dly_p1ms;
 ;Switch triac off
 call Tr_off;
 ;Actual switch off at next zero
 ;crossing
 goto EndVal ;
MaxVal: ;
 ;Switch triac on
 call Tr_on;
 goto EndVal ;
MinVal: ;Switch triac off
 call Tr_off;
 ;Now resume at Endval
EndVal: ;
 ;Main service routine ends here
 ;
 ;Reset to bank 0
 bcf status,rp0;
 ;Clear interrupt flag
 bcf intcon,intf;
 ;
 ;Restore registers
 movf DyVlLpTp,w;
 movwf DyVlLp;
 swapf Status_temp,w;
 movwf status;
 swapf W_temp,f;
 swapf W_temp,w;
 ;Return from interrupt
 ;
 ;+*DBG~~~~~~~~~~~~~~~~~~
 ;return;
 ;+*EDBG~~~~~~~~~~~~~~~~~~
 ;
 retfie;
 ;
 ;END OF INTERRUPT SERVICE ROUTINE
 ;+*EISR~~~~~~~~~~~~~~~~~~~~~~~~~~
 ;
 ;************************************
 ;
 ;BEGINNING OF SUB-ROUTINES
 ;+*BSR~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ;
 ;CONFIGURATION SUB-ROUTINES
 ;+*CSR~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ;
 ;CONFIGURE I/O SUB-ROUTINE
 ;+========================
Con_io: ;
 ;+Set up port a
 ;+-------------
 bsf status,rp0;Bank 1
 movlw %11111111;All inputs - switches on ra0 and ra1
 movwf trisa;
 bcf status,rp0;Bank 0
 ;End of set up port a
 ;
 ;+Set up port b
 ;+-------------
 bsf status,rp0 ;Bank 1
 movlw %00000001;rb1 to rb7 outputs
 ;rb0 input (interrupt)
 movwf trisb;
 bcf status,rp0 ;Bank 0
 ;end of set up port b
 return;
 ;END OF CONFIGURE I/O SUB-ROUTINE
 ;=================================
 ;
 ;END OF CONFIGURATION SUB-ROUTINES
 ;+*ECSR~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ;
 ;INITIALISATION SUB-ROUTINES
 ;+*INITSR~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ;
 ;INITIALISE VARIABLES
 ;+===================
Init_var: ;
 ;Initial light value delay in 1/10ms
 ;Smaller value = brighter
 movlw 70;
 movwf DlyVal;
 ;Switch delay loop counter
 ;Increase for longer delay
 movlw 10;
 movwf SwDlyVal;
 ;
 return;END OF INITIALISE VARIABLES
 ;===========================
 ;
 ;
 ;END OF INITIALISATION SUB-ROUTINES
 ;+*EINITSR~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ;
 ;**************************************
 ;
 ;MAIN PROGRAMME SUB-ROUTINES
 ;+*MPSR~~~~~~~~~~~~~~~~~~~~~
 ;
 ;+CHECK LIGHT UP SUB-ROUTINE
 ;+==========================
Chk_up: ;
 ;Check for switch press otherwise
 ;return
 btfsc porta,up_sw;
 return;
 ;Decrement light value delay unless
 movf DlyVal,w;already 11 (= 1ms) - max value
 ;nb decremented once more if use
 ;timing loop ie not max value
 sublw 11;
 btfss status,z;
 decf DlyVal,f;
 ;Slow down switch action
 call Sw_dly_ms;
 ;
 return;
 ;+END OF CHECK LIGHT UP SUB-ROUTINE
 ;==================================
 ;
 ;+CHECK LIGHT DOWN SUB-ROUTINE
 ;+============================
Chk_dwn: ;
 ;Check for switch press otherwise
 ;return
 btfsc porta,down_sw;
 return;
 ;Increment light value delay unless
 movf DlyVal,w;already 8ms - decremented once
 ;in timing loop
 sublw 81;
 btfss status,z;
 incf DlyVal,f;
 ;Slow down switch action
 call Sw_dly_ms;
 ;
 return;
 ;+END OF CHECK LIGHT DOWN SUB-ROUTINE
 ;====================================
 ;
 ;+TRIAC ON SUB-ROUTINE
 ;+====================
Tr_on: ;
 bsf portb,Triac_drv;
 ;
 return;
 ;+END OF TRIAC ON SUB-ROUTINE
 ;============================
 ;
 ;+TRIAC OFF SUB-ROUTINE
 ;+=====================
Tr_off: ;
 bcf portb,Triac_drv;
 ;
 return;
 ;+END OF TRIAC OFF SUB-ROUTINE
 ;=============================
 ;
 ;+0.1ms DELAY SUB-ROUTINE
 ;+*======================
Dly_p1ms: ;
 movlw 23;
 movwf Nop_count;
 ;
Nop_lp: ;
 nop;
 decfsz Nop_count,f;
 goto Nop_lp ;
 ;
 return ;
 ;+END OF 0.1ms DELAY SUB-ROUTINE
 ;===============================
 ;
 ;+DELAY x_ms SUB-ROUTINE
 ;+*======================
Dly_x_ms: ;
 ;Enter routine with delay time
 ;required in 1/10ms in DyVlLp
X_ms_lp: ;
 call Dly_p1ms;
 decfsz DyVlLp,f;
 ;
 goto X_ms_lp;
 ;
 return ;
 ;+END OF x_ms DELAY SUB-ROUTINE
 ;===============================
 ;
 ;+SWITCH DELAY SUB-ROUTINE
 ;+*=======================
Sw_dly_ms: ;
 ;Enter routine with delay time
 ;required in 1/10ms in DyVlLp
Sw_ms_lp: ;
 ;Enter routine with switch delay
 ;in 1/10 ms in SwDlyVal
 call Dly_p1ms;
 decfsz SwDlyVal,f;
 ;
 goto Sw_ms_lp;
 ;
 return ;
 ;+END OF SWITCH DELAY SUB-ROUTINE
 ;================================
 ;
 end;
 ;END OF PROGRAMME CODE
 ;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
